#!/usr/bin/perl -w

#
# AUTHOR: Krunk
# Website: http://www.krunk4ever.com
#

# libraries
use File::Basename;
use File::Copy;
use Getopt::Std;

# user variables
glob @vidExts = ( ".avi", ".mp4", ".mov", ".mkv", ".ogm", ".wmv", ".mpg", ".ts" );
glob $mplayer = "C:/Downloads/MPlayer-mingw32-1.0rc2/MPlayer-1.0rc2/mplayer.exe";
glob $startPath = ".";     # sets the start path to the current working directory
glob $screenshotTime = 300;     # in seconds
glob $force = 0;                # set to 1 to enable force generate all thumbnails
                                # otherwise it'll skip files that already have thumbnails

# system variables
glob $defaultFileName = "00000001.jpg";
glob $processedVids = 0;
glob %isVidExt;
glob @failedList = ();

# generate inverse array for quick lookup
for ( @vidExts ) { $isVidExt{ $_ } = 1; }

# parse arguments/options
my %options=();
getopts( 'hH?d:ft:', \%options );

if( $options{'h'} || $options{'H'} || $options{'?'} )
{
    main::HELP_MESSAGE();
}

if( $options{'d'} )
{
    $startPath = $options{'d'};
}
if( $options{'t'} )
{
    $screenshotTime = $options{'t'};
}
if( $options{'f'} )
{
    $force = 1;
}

# make sure arguments/options are valid
if( !-d $startPath )
{
    die( "Invalid Directory: $startPath" );
}
if( !IsWholeNumber( $screenshotTime ) )
{
    die( "Invalid Screenshot Time: $screenshotTime" );
}

print "Generating Thumbnails for all videos under: $startPath\n";

GenerateThumbnailsIn( $startPath );

print "Processed Videos: $processedVids\n";
print "Failed Videos:\n";
foreach my $failedVid ( @failedList )
{
    print "\t$failedVid\n";
}





# parses the directory and generates the thumbnail
# also recursively parses subdirectories
sub GenerateThumbnailsIn
{
    my( $path ) = @_;

    # discard last character if it's a \ or /
    my $lastChar = substr( $path, -1 , 1 );
    if( $lastChar eq "\\" or $lastChar eq "/" )
    {
        chop( $path );
    }
    
    opendir( DIR, $path ) || die( "Cannot open directory: " . $path );
    my @files = readdir( DIR );
    closedir( DIR );
    
    foreach my $file ( @files )
    {
        
        if( -d "$path/$file" )
        {
            if( substr( $file, 0, 1 ) ne "." )
            {
                GenerateThumbnailsIn( "$path/$file" );
            }
        }
        elsif( -f "$path/$file" )
        {
            my ( $fname, $fpath, $fsuffix ) = fileparse( "$path/$file", @vidExts );
            
            if( $isVidExt{ $fsuffix } && ( $force || !-f "$path/$fname.jpg" ) )
            {
                print "Processing: $path/$file\n";
                my $command = "\"$mplayer\" -vo jpeg -frames 1 -ss $screenshotTime -nosound \"$path/$file\" >> gerenateThumbnails.log";
                system( $command ) == 0 || push( @failedList, "$path/$file" );
                move( $defaultFileName, "$path/$fname.jpg" );
                $processedVids++;
            }
        }
    }
}

# checks to see if the paramenter is a whole number or not
sub IsWholeNumber { $_[0] =~ /^\d+$/ }

# HELP message
sub main::HELP_MESSAGE
{
    print "Usage: generateThumbnails.pl [-OPTIONS [-MORE_OPTIONS]]\n\n";
    print "OPTIONS:\n";
    print "\t-d StartingDirectory\tSets the starting directory [cwd]\n";
    print "\t-f\t\t\tForces Thumbnail Generation [off]\n";
    print "\t-t TimeInSecs\t\tTime in video to grab screenshot [300s]\n";
    exit;
}